// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn., Prentice-Hall International

//Chapter-1: Introduction to Engineering principles and units 
//Example 1.4-2 Page 9
// Title: Composition of Gas mixture 
//=====================================================
model Ex1_4_2

//=====================
// Parameter section
parameter Real pa(unit = "mmHg")=75 "Partial pressure of CO2";
parameter Real pb(unit = "mmHg")=50 "Partial pressure of CO";
parameter Real pc(unit = "mmHg")=595 "Partial pressure of N2";
parameter Real pd(unit = "mmHg")=26 "Partial pressure of O2";

//=====================
//Variable section
Real P(unit = "mmHg") "Total system pressure";
Real xa(unit = "-") "Mole fraction of CO2";

//=====================
//Equation section
equation
P = pa + pb + pc + pd; // Total pressure of the system
xa = pa/P; // Mole fraction of CO2
end Ex1_4_2;
//=====================================================
