// C.J. Geankopolis, Transport processs and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-10 Stage and continuous gas-liquid separation processes
//Example 10_3_3 Page:593
//Title: Number of stages by analytical equation
//================================================
model Ex10_3_3

//================
//Parameter section
parameter Real Lo(unit = "kmol/hr") = 90 "Liquid incoming flow rate";
parameter Real V1(unit = "kmol/hr") = 29.73 "Vapor leaving flow rate";
parameter Real m(unit = "-") =2.53 "Slope of equilibrium line";
parameter Real yaN(unit = "-") = 0.01 "Mole fraction of inlet gas stream";
parameter Real ya1(unit = "-") = 0.00101 "Mole fraction of exit gas stream";
parameter Real xao(unit = "-") = 0 "Mole fraction of inlet liquid stream";

//================
//Variable section
Real A(unit = "-") "Absorption factor";
Real N(unit = "-") "Number of stages required for separation";

//================
//Equation section
equation
A = Lo/(m*V1) ; // Absorption factor
N = log(((yaN - m*xao)/(ya1 - m*xao))*(1-1/A)+1/A)/(log(A)) ; // Number of stages
end Ex10_3_3;
//=================================================
