// C.J. Geankopolis, Transport processs and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-10 Stage and continuous gas-liquid separation processes
//Example 10_6_1 Page:625
//Title: Use of transfer units for packing tower
//================================================
model Ex10_6_1

//=================
//Parameter section
parameter Real Lo(unit = "kmol/m^2.hr") = 6000 "Liquid incoming flow rate";
parameter Real Vo(unit = "kmol/m^2.hr") = 150 "Vapor incoming flow rate";
parameter Real yaN[5] = {0.2,0.16,0.12,0.08,0.04} "Mole fraction of inlet gas stream";
parameter Real xao(unit = "-") = 0 "Mole fraction of inlet liquid stream";
parameter Real ya1(unit = "-") = 0.02 "Mole fraction of exit gas stream";
parameter Real Ma(unit = "kg/kmol") = 29 "Molecular weight of air";
parameter Real Mb(unit = "kg/kmol") = 18 "Molecular weight of water";

//===============
//Variable section
Real xN[5](unit = "-") "Mole fraction of solute in liquid";
Real L1(unit = "kmol/m^2.hr") "Molar flow rate of liquid leaving";
Real V1(unit = "kmol/m^2.hr") "Molar flow rate of vapor leaving";

//=================
//Equation section
equation
L1 = Lo/Mb ; // Molar flow rate of liquid
V1 = Vo/Ma ; // Molar flow rate of vapor
for i in 1:5 loop
L1*(xao/(1-xao))+V1*(yaN[i]/(1-yaN[i])) = L1*(xN[i]/(1-xN[i]))+V1*(ya1/(1-ya1)) ; // Mass balance equation
// For illustration purpose the values are chosen for yaN and corresponding xN are calculated. It is the data for operating line. The equilibrium data has to be found and the both are plotted to find number of trays
end for;
end Ex10_6_1;
//====================================================================
