// C.J. Geankopolis, Transport processs and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-11 Vapor liquid separation processes
//Example 11_1_1 Page:641
//Title: Use of Raoults law for boiling point diagram
//================================================
model Ex11_1_1

//=================
//Parameter section
parameter Real P(unit = "kPa") = 101.325 "Total system pressure";
parameter Real pa(unit = "kPa") = 155.7 "Partial pressure of A";
parameter Real pb(unit = "kPa") = 63.3 "Partial pressure of B";

//=================
//Variable section
Real xa(unit = "-") "Mole fraction of liquid benzene";
Real xb(unit = "-") "Mole fraction of liquid toluene";
Real ya(unit = "-") "Mole fraction of vapor benzene";

//=================
//Equation section
equation
P = xa*pa+(1-xa)*pb ; // Mole fraction of benzene
ya*P = xa*pa ; // Raoult's law
xb = 1-xa ; // Mole fraction of toluene
end Ex11_1_1;
//================================================
