// C.J. Geankopolis, Transport processs and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-11 Vapor liquid separation processes
//Example 11_3_2 Page:647
//Title: Simple differential distillation 
//================================================
model Ex11_3_2

//===============
//Parameter section
parameter Real F(unit = "kmol/h") = 100 "Feed mole flow rate";
parameter Real D(unit = "kmol/h") = 60 "Distillate mole flow rate";
parameter Real x[6] = {0.594,0.398,0.254,0.145,0.059,0} "Data of x";
parameter Real y[6] = {0.925,0.836,0.701,0.521,0.271,0} "Data of y";
parameter Real xf(unit = "-") = 0.5 "Feed composition";

//===============
//Variable section
Real LHS(unit = "-") "Left hand side of the simple distillation equation";
//Real x2(unit = "-") "Final composition of solute";
Real yavg[5] "Area under the curve parameter";
Real delx[5] "Area under the curve parameter";
Real area(unit = "-") "Total area";
Real B(unit = "kmol/h") "Flow rates of bottom";
Real yav(unit = "-") "Composition of vapor";

//===============
//Equation section
equation
LHS = log(F/D) ; // Left hand side of the equation
for i in 1:5 loop
yavg[i] = 1/(y[i] - x[i]) ; // Y average
delx[i] = x[i] - x[i+1] ; // Del x
end for;
area = sum(yavg[:])*sum(delx[:]) ;
// The values are plotted in a graph and the point at which LHS = RHS is found
//From plot of values xd is obtained as 0.277
F = D + B ; // Overall mterial balance equation
F*xf = D*0.277 + B*yav; // Component balance equation
end Ex11_3_2;
//=====================================================
