// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-12 Liquid-Liquid and fluid-solid separation processes
//Example 12_11_2 Page:741
//Title: Heat balance in crystallization process
//================================================
model Ex12_11_2

//=============
//Parameter section
parameter Real F(unit = "kg/hr") = 2268 "Feed flow rate";
parameter Real xf(unit = "-") = 0.482 "Composition of feed";
parameter Real sol(unit = "kg/kg") = 35.5 "Solublity of solute in the solution";
parameter Real T(unit = "kg") = 100 "Total amount of water present";
parameter Real Cpf(unit = "kJ/kg.K") = 2.93 "Heat capacity of feed";
parameter Real HS(unit = "kJ/kmol") = -13.33E+03 "Heat of solution";
parameter Real Ts(unit = "K") = 293.2 "Reference temperature";
parameter Real T1(unit = "K") = 327.6 "Crystallization temperature";

//=============
//Variable section
Real C(unit = "kg/hr") "Amount of crystals formed";
Real S(unit = "kg/hr") "Amount of saturated solution formed";
Real HF(unit = "kJ") "Enthalpy of feed";
Real Hs(unit = "kJ/kg") "Enthalpy of solution";
Real Hc(unit = "kJ/kg") "Enthalpy of crystal";
Real q(unit = "kJ") "Total heat released in the process";

//==============
//Equation section
equation
(1-(xf/(1+xf)))*F = T*S/(T + sol) + (126/246.49)*C ; // Water  balance 
(xf/(1+xf))*F = sol*S/(T + sol) + (126/246.49)*C  ; // Solute balance
 // 126 is the Molecular weight of MgSO4
HF = F*(T1 - Ts)*Cpf ; // Enthalpy of feed
Hs = HS/246.49 ; // Heat of solution
 // 246.49 is the molecular weight of MgSO4.7H2O
Hc = C*(-Hs) ; // Heat of crystals
q = -HF-Hc ; // Total heat released in the process
 // There is a slight deviation in answer
end Ex12_11_2;
//=============================================
