// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-12 Liquid-Liquid and fluid-solid separation processes
//Example 12_3_1 Page:704
//Title: Scale up of laboratory adsorption column
//================================================
model Ex12_3_1

//==============
//Parameter section
parameter Real CtoCo[3] = {1,1,0.998};
parameter Real t[3] = {0,3,3.5};
parameter Real A1(unit = "hr") = 3.65 "Graphical integration till break point time";
parameter Real A2(unit = "hr") = 1.51 "Graphical integration after break pont time";
parameter Real tb1(unit = "hr") = 3.65 "Break point time 1";
parameter Real tb2(unit = "hr") = 6 "Break point 2";
parameter Real d(unit = "cm") = 4 "Diameter of the bed";
parameter Real TC(unit = "g") = 79.2 "Total amount of carbon present";
parameter Real HT1(unit = "cm") = 14 "Length of the bed";
parameter Real co(unit = "ppm") = 600 "Inlet gas concetrtion";
parameter Real rho(unit = "g/cm^3") = 0.00115 "Density of gas stream";
parameter Real Q(unit = "cm^3/s") = 754 "Flow rate of gas";

//==============
//Variable section
Real tt(unit  = "hr") "Time equivalent to stochiometric capacity of bed";
Real tu(unit = "hr") "Time equivalent to usable capacity of the bed";
Real HUNB(unit = "cm") "Length of unused bed";
Real HB1(unit = "cm") "New height of the bed in case 1";
Real HB2(unit = "cm") "New height of the bed in case 2";
Real HT2(unit = "cm") "Total height in case 2";
Real air_flow(unit = "kg of air/hr") "Flow rate of air";
Real T_ads(unit = "g")  "Total alcohol adsorbed";
Real sat_capacity(unit = "g-alcohol/g-carbon") "Saturation capacity of bed";
Real delx[2] "Area under the curve parameter";
Real yavg[2] "Area under the curve parameter";
Real A(unit = "-") "Area under the curve";

//==============
//Equation section
equation
//Case 1
tt = A1 + A2 ; // Total time
tu = tb1 ; // Time equivalent to usable bed capacity 
HUNB = (1-(tu/tt))*HT1 ; // Unused bed
HB1 = (tu/tt)*HT1; // Height of bed in case 1
//Case 2; tb = 6 hrs
HB2 = (tb2/tb1)*HB1 ; // Height of bed in case 2
HT2 = HB2 + HUNB ; // Total bed height 
air_flow = rho*Q*3600 ; // Flow rate of gas
 // Multiplied by 3600 to convert "seconds" to "hours"
T_ads = (co/10^06)*tt*air_flow; // Total solute adsorbed
 // co is divided by 10^6 to convert "ppm" to "g"
sat_capacity = T_ads/TC ; // Saturation capacity
for i in 1:2 loop
delx[i] = t[i+1]-t[i];
yavg[i] = (CtoCo[i]+CtoCo[i+1])/2 ;
end for;
A = sum(delx[:]).*(sum(yavg[:])) ;
end Ex12_3_1;
//===================================================
