// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-12 Liquid-Liquid and fluid-solid separation processes
//Example 12_5_2 Page:714
//Title: Amounts of phases in solvent extract
//================================================
model Ex12_5_2

//=============
//Parameter section
parameter Real M(unit = "kg/hr") = 100 "Total mixture weight";
parameter Real ya(unit = "-") = 0.04 "Composition of A in extract layer";
parameter Real xa(unit = "-") = 0.12 "Composition of B in raffinate layer";
parameter Real xam(unit = "-") = 0.10 "Composition of mixture";

//=============
//Variable section
Real L(unit = "kg/hr") "Liquid flow rate";
Real V(unit = "kg/hr") "Vapor flow rate";
Real L_G(unit = "kg/hr") "Liquid flow rate";
Real V_G(unit = "kg/hr") "Vapor flow rate";

//=============
//Equation section
equation
V + L = M ; // Over all material balance equation
V*ya + L*xa = M*xam; // Component balance
 // Using left arm rule from figure, figure 12.5-3 is measured as hg = 4.2, gi = 5.8 
L_G/M = 4.2/5.8 ; // Liquid flow rate obtained using left hand rule
L_G + V_G = M; // Vapor flow rate obtained using left hand rule
end Ex12_5_2;
//=================================================
