// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-12 Liquid-Liquid and fluid-solid separation processes
//Example 12_7_3 Page:722
//Title: Extraction of nicotine from immissible liquid
//================================================
model Ex12_7_3

//=============
//Paramter section
parameter Real Lo(unit = "kg/hr") = 100 "Inlet water solution";
parameter Real Vo(unit = "kg/hr") = 200 "Inlet solvent flow rate";
parameter Real xo(unit = "-") = 0.01 "Composition solute at inlet";
parameter Real xn(unit = "-") = 0.001 "Composition of solute at exit";
parameter Real yn(unit = "-") = 0.0005 "Composition of solute in kerosene";

//=============
//Variable section
Real L(unit = "kg/hr") "Flow rate of aquous solution";
Real V(unit = "kg/hr") "Flow rate of solvent";
Real y1(unit = "-") "Composition of solute at exit";

//==============
//Equation section
equation
L = Lo*(1 - xo); // Flow rate of aquous solution
V = Vo*(1 - yn) ; // Flow rate of solvent
L*(xo/(1-xo)) + V*(yn/(1-yn)) = L*(xn/(1-xn)) + V*(y1/(1-y1)) ; // Composition of solute at outlet
 // Using the above information the operating and equilibrium lines are constructed and number of stages are foung to be 3.8
end Ex12_7_3;
//=================================================
