// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-13: Memberane seperation process
//Example 13.2-1 Page 756
//Title: Memberane diffusion and liquid film resistance
//================================================
model Ex13_2_1

//===============
//Parameter section
parameter Real c1(unit = "kmol/m^3") = 3E-02 "Initial concentration of the solute";
parameter Real c2(unit = "kmol/m^3") = 0.5E-02 "Final concentration of the solute";
parameter Real L(unit = "m") = 3E-05 "Memberane thickness";
parameter Real K(unit = "-") = 1.5 "Distribution coefficient";
parameter Real kc2(unit = "m/s") = 2.02E-05 "Mass transfer coefficient at section 2";
parameter Real Dab(unit = "m^2/s") = 7E-11 "Difusion coefficient";

//==============
//Variable section
Real Pm(unit = "m/s") "Premeablity of liquid";
Real Na(unit = "kmol/m^2.S") "Flux of the liquid";
Real Ci(unit = "kmol/m^3") "Intrface concentration";
Real Cis(unit = "kmol/m^3") "Interface concentration between Ci and c2" ;

//===============
//Equation section
equation
Pm = Dab*K/L ; // Permeablity of the fluid
Na = (c1 - c2)/((1/Pm) + (1/kc2)) ; // Flux of the fluid 
Na = kc2*(Ci - c2); // Inteface concentration
K = Cis/Ci ; // Interface concentration between Ci and c2
end Ex13_2_1;
//===============================================
// Note : The part-a of the problem is derivation
//=================================================
