// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-13: Memberane seperation process
//Example 13.9-1 Page 784
//Title: Calculation of osmotic pressure of salt solution
//================================================
model Ex13_9_1

//===============
//Parameter section
parameter Real n(unit = "kmol") = 2E-04 "Moles of Nacl";
parameter Real R(unit = "-") = 82.057E-03 "Ideal gas constant";
parameter Real T(unit = "K") = 298 "Operating Temperature";
parameter Real Vm(unit = "m^3") = 1/997 "Volume of pure solvent water";

//===============
//Variable section
Real pi(unit = "atm") "Osmotic pressure";

//================
//Equation section
equation
pi = n*R*T/Vm ; // Osmotic pressure 
end Ex13_9_1;
//================================================
