// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-14: Mechanical-Physical separation processes
//Example 14.2-1 Page 810
//Title: Evaluation of filtration constants for constant pressure filtration
//================================================
model Ex14_2_1

//=============
//Parameter section
parameter Real Kp(unit = "s/m^6") = 6E06 "Slope obtained by plotting the given data";
parameter Real B(unit = "s/m^3") = 6400 "Intercept from the given data";
parameter Real Delp(unit = "kN/m^2") = 338 "Constant pressure drop";
parameter Real A(unit = "m^2") = 0.0439 "Filter area of plate and frame";
parameter Real cs(unit = "kg/m^3") = 23.47 "Concentration of the slurry";
parameter Real mu(unit = "Pa.s") = 8.937E-04 "Viscosity of water at given conditions";

//=============
//Variable section
Real alpha(unit = "m/kg") "Filter cake resistance";
Real Rm(unit = "m^-1") "Resistance offered by filter medium";

//=============
//Equation section
equation
Kp = (mu*alpha*cs)/(A^2 * (Delp*1000)) ; // Filter cake resistance
B = (mu*Rm)/(A*(Delp*1000)) ; //Resistance offered by filter medium
   // 1000 is multiplied to convert kN/m^2 to N/m^2
end Ex14_2_1;
//================================================
