// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-14: Mechanical-Physical separation processes
//Example 14.2-4 Page 814
//Title: Filtration in a continuous rotary drum filter
//================================================
model Ex14_2_4

//===============
//Parameter section
parameter Real rho(unit = "kg/m^3") = 996.9 "Density of water";
parameter Real cx(unit = "kg solid/kg.slurry") = 0.191 "Amount of solid present in slurry";
parameter Real m(unit = "kg wet cake/kg dry cake") = 2 "Ratio of wet solid to dry solid";
parameter Real Delp(unit = "kPa") = 67 "Pressure drop of filter";
parameter Real f(unit = "-") = 0.33 "Fraction submerged into the drum";
parameter Real mu(unit = "Pa.s") = 0.8937E-03 "Viscosity of the water";
parameter Real t(unit = "s") = 250 "Time required filter cycle";

//==============
//Variable section
Real cs(unit = "kg/m^3") "Concentration of the filtrate";
Real Vt(unit = "m^3/s") "Volumetric flow rate";
Real alpha(unit = "m/kg") "Compressiblity of cake";
Real A(unit = "m^2") "Area of filtrate";

//===============
//Equation section
equation
alpha = 4.39E09*(Delp*10^3)^0.3; // Compressiblity of cake
cs = (rho*cx)/(1-(m*cx)) ; // Concentration of slurry
Vt = 0.778*cx*(1/cs) ; // Flowrate of filtrate
Vt/A = ((2*f*Delp*1000)/(t*mu*cs*alpha))^0.5 ; // Area of filter
 // 1000 is multiplied to convert kPa to Pa
end Ex14_2_4;
//======================================================
