// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-14: Mechanical-Physical separation processes
//Example 14.3-3 Page 824
//Title: Separation of mixture of silica and galena
//================================================
model Ex14_3_3

//=============
//Parameter section
parameter Real D_min(unit = "m") = 5.21E-06 "Minimum diameter of the range of particles";
parameter Real D_max(unit = "m") = 2.5E-05 "Maximum diameter of the range of particles";
parameter Real rho(unit = "kg/m^3") = 998 "Density of water";
parameter Real rhoA(unit = "kg/m^3") = 7500 "Density of particle A";
parameter Real rhoB(unit = "kg/m^3") = 2650 "Density of particle B";
parameter Real mu(unit = "Pa.s") = 1.005E-03 "Viscosity of the fluid";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration dure to gravity";

//=============
//Variable section
Real v(unit = "m/s") "Terminal velocity of the particle";
Real NRe(unit = "-") "Reynolds number of the particle";
Real D3(unit = "m") "Diameter of particle 3";
Real D2(unit = "m") "Diameter of particle 2";

//=============
//Equation section
equation
v = (D_max^2*(rhoA-rho)*g)/(18*mu) ; //Terminal settling velocity
NRe = (D_max*rho*v)/mu ; // Reynolds number of the particle
D3/D_max = ((rhoB - rho)/(rhoA - rho))^0.5 ; // Diameter of mixture of particle 3
D_min/D2 = ((rhoB - rho)/(rhoA - rho))^0.5 ; // Diameter of mixture of particle 2
  // The size fraction of first fraction is from D3 to D_max
  // The size fraction of mixed fraction is from D2 to D_max and D_min to D3
  // The size fraction of third fraction is from D_min to D2
end Ex14_3_3;
//==========================================================
