// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-14: Mechanical-Physical separation processes
//Example 14.4-1 Page 831
//Title: Separation of mixture of silica and galena
//================================================
model Ex14_4_1

//================
//Parameter section
parameter Real r1(unit = "m") = 0.1016 "Radius of the bowl in case 1";
parameter Real r2(unit = "m") = 0.2032 "Radius of bowl in case 2";
parameter Real N(unit = "rev/min") = 1000 "Number of revolutions per minute";

//================
//Variable section
Real Fc_1(unit = "g's") "Force developed in terms of gravity in case 1";
Real Fc_2(unit = "g's") "Force developed in terms of gravity in case 2";

//================
//Equation section
equation
Fc_1 = 0.001118*r1*N^2 ;// Force developed in case 1
Fc_2 = 0.001118*r2*N^2 ; // Force developed in case 2 
end Ex14_4_1;
//=============================================
