// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-14: Mechanical-Physical separation processes
//Example 14.4-2 Page 833
//Title: Settling in a centrifuge
//================================================
model Ex14_4_2

//===============
// Libraries 
extends Modelica.Constants;

//=============
//Parameter section
parameter Real N(unit = "rev/min") = 23000 "Speed of rotation of centrifuge";
parameter Real rho(unit = "kg/m^3") = 801 "Density of solution";
parameter Real rhop(unit = "kg/m^3") = 1461 "Density of solid particles";
parameter Real mu(unit = "cP") = 100 "Viscosity of the solution";
parameter Real r1(unit = "m") = 0.00716 "Inner radius of the bowl";
parameter Real r2(unit = "m") = 0.02225 "Inner radius of the bowl";
parameter Real b(unit = "m") = 0.197 "Inner radius of the bowl";
parameter Real q(unit = "m^3/hr") = 0.002832 "Volumetric flow rate";

//=============
//Variable section
Real omega(unit = "rad/s") "Speed of rotation of centrifuge";
Real V(unit = "m^3") "Volume of bowl";
Real qc(unit = "m^3/s") "Volumetric flow rate";
Real D(unit = "m") "Diameter of the largest particle";

//=============
//Equation section
equation
omega = 2*pi*N/60 ; // Speed of revolution of centrifuge
V = pi*b*(r2^2 - r1^2) ; // Volume of bowl
qc = q/3600 ; // Volumetric flowrate
qc = (omega^2*D^2*V*(rhop-rho))/((18*mu/1000)*log(2*r2/(r1+r2))); // Diameter of the particle
end Ex14_4_2;
//======================================================
