// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.10-2 Page 87
//Title: Using friction factor for laminar flow
//================================================
model Ex2_10_2

//===============
//Parameter section
parameter Real D(unit = "m") = 2.22E-03 "Diameter of capillary";
parameter Real rho(unit = "kg/m^3") = 875 "Density of fluid";
parameter Real V(unit = "m/s") = 0.275 "Velocity of fluid";
parameter Real mu(unit = "Pa.s") = 1.13E-03 "Viscosity of fluid";
parameter Real L(unit = "m") = 0.317 "Length of the capillary";

//==============
//Variable section
Real Delp(unit = "N/m^2") "Pressure drop";
Real NRe(unit = "-") "Reynolds number";
Real f(unit = "-") "Friction factor";

//===============
//Equation section
equation
NRe = (D * rho * V )/ mu ; // Reynolds number
f = 16/NRe ; // Friction factor
Delp = f*4*rho*(V^2/2)*(L/D) ; //Pressure drop
end Ex2_10_2;
//=================================================
