// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.10-7 Page 97
//Title: Friction loss and Mechanical energy balance
//================================================
model Ex2_10_7

//=============
//Parameter section
parameter Real mu(unit = "kg/m.s") = 1.005E-03 "Viscosity of fluid";
parameter Real rho(unit = "kg/m^3") = 998.2 "Density of fluid";
parameter Real Q(unit = "m^3/s") = 5E-03 "Volumertic flow rate";
parameter Real D(unit = "m") = 0.1023 "diameter of pipe";
parameter Real z1(unit = "m") = 15 "Height of section 2";
parameter Real A1(unit = "m^2") = 0 "Area of tank";
parameter Real A(unit = "m^2") = 8.219E-03 "Area of pipe";
parameter Real V(unit = "m/s") = 0.6083 "Velocity of fluid";
parameter Real L2(unit = "ft") = 170 "Length upto the section 2";
parameter Real K3(unit = "-") = 0.75 "Loss coefficient in section 3";
parameter Real f2(unit = "-") = 0.0051 "friction factor in section 2";
parameter Real eff(unit = "-") = 0.65 "efficiency of pump";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";

//=============
//Variable section
Real K1(unit = "-") "Contraction Loss coefficient in section 1";
Real K4(unit = "-") "Contraction Loss coefficient in section 4";
Real h1(unit = "J/kg") "head loss in in tank exit";
Real h2(unit = "J/kg") "head loss in section 2";
Real h3(unit = "J/kg") "head loss in section 3"; 
Real h4(unit = "J/kg") "head loss in section 4";
Real NRe(unit = "-") "Reynold number";
Real F(unit = "J/kg") "Total head loss";
Real Ws(unit = "J/kg") "Shaft work";
Real Wp(unit = "J/kg") "pump power";
Real M(unit = "kg/s") "Mass flow rate of the fluid";
Real pow(unit = "kW") "Power in kW";

//=============
//Equation section
equation
M = Q*rho; // Mass flow rate
NRe =(D*rho*V)/mu ;
K1 = 0.55*(1); //Contraction Loss coefficient in 4-inch pipe
h1 = K1*(V^2/2);// head loss in in tank exit
h2 = 4*f2*(V^2/2)*(L2/D) ; // head loss in section 2
h3 = K3*(V^2/2) ; //head loss in 4-inch elbow
K4 = (1-(A1/A)) ; // Loss coefficient in 4-2 inch pipe
h4 = K4*(V^2/(2)) ; //head loss in 4-2 inch pi
F = h1+h2+h3+h4; // Total loss
g*(z1) + F + Ws = 0;
Ws = -eff*Wp; // Pumping power
pow = M*(Wp/1000) ; 
    // pow is divided by 1000 to conver to kW
end Ex2_10_7;
//================================================
