// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.11-2 Page 103
//Title: Maximum flow for compressible flow of natural gas
//================================================
model Ex2_11_2

//===============
// Libraries 
extends Modelica.Constants;

//============
//Parameter section
parameter Real D(unit = "m") = 1.016 "Diameter of tube";
parameter Real F(unit = "kgmol/s") = 2.077 "Molar flow rate of fluid";
parameter Real P2(unit = "Pa") = 170.3E+03 "Pressure at inlet";
parameter Real R(unit = "J/kmol.K") = 8314.34 "Ideal gas constant";
parameter Real T(unit = "K") = 288.15 "Temperature of the fluid";
parameter Real MW(unit = "kg/kmol") = 16 "Molecular weight of flowing fluid";

//============
//Variable section
Real G(unit = "kg/m^2.s") "Mass velocity";
Real vmax(unit = "m/s") "Maximum velocity";
Real A(unit = "m^2") "Area of cross section";
Real v2(unit = "m/s") "Actual velocity";

//============
//Equation section
equation
A = (pi/4)*D^2 ; //Area of pipe
G = F*MW/A ; // Mass velocity
(vmax) = sqrt(R*T/MW); // Maximum velocity
v2 = R*T*G/(P2*MW); // Actual velocity
end Ex2_11_2;
//===============================================
