// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.2-4 Page 37
//Title: Pressure Difference in Manometer
//================================================
model Ex2_2_4

//==============
//Parameter section
parameter Real rho_a(unit = "g/cm^3") = 13.6 "Density of fluid A";
parameter Real rho_b(unit = "g/cm^3") = 1 "Density of  fluid B";
parameter Real R(unit = "cm") = 32.7 "Manometer reading";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";

//=============
//Variable section
Real deltaP(unit = "N/m^2") "Pressure difference between two limbs";

//==============
//Equation Section
equation
deltaP = (R/100)*(rho_a - rho_b)*1000*g ; // Pressure drop across the limbs
       // R is divided by 100 to convert it from cm to m
       // rho id divided by 1000 to convert it to kg/m^3
end Ex2_2_4;
//==================================================
