// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.3-1 Page 41
//Title: Molecular transport of a property at steady state
//================================================
model Ex2_3_1

//===============
//Parameter section
parameter Real c1(unit = "property/m^3") = 1.37E-02 "Concentration at plane 1";
parameter Real c2(unit = "property/m^3") = 0.72E-02 "COncentration at plane 2";
parameter Real D(unit = "m^2/s") = 0.013 "Diffusivity of the fluid";
parameter Real z1(unit = "m") = 0 "Distance from plane 1";
parameter Real z2(unit = "m") = 0.4 "Distance from plane 2";

//===============
//Variable section
Real N(unit = "property/s.m^2") "Flux of the fluid";
Real cmid(unit = "property/m^3") "Concentration at mid point between the the planes";

//================
//Equation section
equation
N = D*(c1 - c2)/(z2 - z1) ; //Flux of the cross sectional area
cmid = c1 + (N/D)*(z1 - z2/2); // Concentration at mid point
         // z2 is divided by 2, because in question it is asked for mid point
end Ex2_3_1;
//=======================================================
