// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.7-3 Page 62
//Title: Energy balance on flow calorimeter
//================================================
model Ex2_7_3

//=============
//Parameter section
parameter Real m1(unit = "kg/min") = 0.3964 "Mass flow rate in kg/min";
parameter Real heat(unit = "kW") = 19.63 "Energy added to the system";
parameter Real vel_head(unit = "kJ/kg") = 0 "velocity head";
parameter Real potential_head(unit = "kJ/kg") = 0 "potential head";
parameter Real H1(unit = "kJ/kg") = 0 "Enthalpy at temperature at section 1";  

//=============
//Variable section
Real M(unit = "kg/s") "Mass flow rate of fluid";
Real Q(unit = "kJ/kg") "Heat added to system per kg of working fluid";
Real H2(unit = "kJ/kg") "Enthalpy at section 2";

//=============
//Equation section
equation
M = m1/60 ; // Mass flow rate
     // m1 is divided by 60 to convert min to sec
Q = heat/M ; // Heat added
Q = (H2 -H1); // Enthalpy at section 2
end Ex2_7_3;
//================================================
