// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.7-4 Page 64
//Title: Mechanical energy balance on pumps
//================================================
model Ex2_7_4

//=============
//Parameter section 
parameter Real P1(unit = "kN/m^2") = 68.9 "Inlet pressure";
parameter Real P2(unit = "kN.m^2") = 137.8 "Exit pressure";
parameter Real z1(unit = "m") = 0 "Height at section 1";
parameter Real z2(unit = "m") = 3.05 "Height at section 2";
parameter Real Ws(unit ="J/kg") = -155.4 "Shaft work";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";
parameter Real vel_head(unit = "J/kg") = 0 "Velocity head";
parameter Real rho(unit = "kg/m^3") = 998 "Density of fluid";

//=============
//Variable section
Real F(unit = "J/kg") "Frictional losses" ;

//==============
//Equation section
equation
F = -Ws + vel_head + g*(z1-z2) + (P1*1000/rho) - (P2*1000/rho) ; // Frictional losses
end Ex2_7_4;
//===================================================
