// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-3: Flow past immersed objects and packed and fluidised bed
//Example 3.1.-3 Page 119
//Title: Surface area in packed bed of cylinder
//================================================
model Ex3_1_3

//===============
// Libraries 
extends Modelica.Constants;

//===============
//Parameter section
parameter Real rho1(unit = "kg/m^3") = 962 "Density of packed bed";
parameter Real rho2(unit = "kg/m^3") = 1600 "Density of solid cylinder";
parameter Real d(unit = "m") = 0.02 "Diameter of the cylinder";

//===============
//Variable section
Real v(unit = "m^3") "Volume of the cylinder";
Real epslon(unit = "-") "Void fraction of the bed";
Real dp(unit = "m") "Effecive diameter";
Real a(unit = "m^-1") "Ratio of total surface area to total volume area";
Real av(unit = "m^-1") "Ratio of surface area to volume";

//===============
//Equation section
equation
v = rho1/rho2 ; //volume of cylinder
epslon = (1 - v)/1 ; // Void fraction of the bed
av = 6/d ; //Ratio of surface area to volume
dp = 6/av ; // Effective diameter
a = (6/dp)*(1-epslon) ; // Ratio of total surface area to total volume area
end Ex3_1_3;
//============================================
