// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-3: Flow past immersed objects and packed and fluidised bed
//Example 3.1-5 Page 122
//Title: Mean diameter for particle mixture
//================================================
model Ex3_1_5

//===============
// Libraries 
extends Modelica.Constants;

//===============
//Parameter section
parameter Real x1(unit = "-") = 0.25  "Mass fraction of the 1 st particle";
parameter Real Dp1(unit = "mm") = 25  "Diameter of 1st group of particles";
parameter Real x2(unit = "-") = 0.40  "Mass fraction of the 2nd particle";
parameter Real Dp2(unit = "mm") = 50  "Diameter of 2nd group of particles";
parameter Real x3(unit = "-") = 0.35  "Mass fraction of the 3rd particle";
parameter Real Dp3(unit = "mm") = 75  "Diameter of 1st group 3rd particles";
parameter Real epslon(unit = "-") = 0.68 "Sphericity of particle";
 
 //===============
//Variable section
Real Dpmean(unit = "mm") "Mean diameter of particle mixture";
Real A(unit = "mm^-1") "Mean dia of 1 st particle";
Real B(unit = "mm^-1") "Mean dia of 2nd particle";
Real C(unit = "mm^-1") "Mean dia of 3rd particle";

//===============
//Equation section
equation
A = x1/(Dp1*epslon) ; // Mean dia of 1st particle
B = x2/(Dp2*epslon) ; // Mean dia of 2nd particle
C = x3/(Dp3*epslon) ; // Mean dia of 3rd particle
Dpmean = 1/(A + B + C) ; //Mean dia of particle mixture
end Ex3_1_5;
//====================================================
