// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-3: Flow past immersed objects and packed and fluidised bed
//Example 3.1-6 Page 125
//Title: Minimum velocity of fluidization
//================================================
model Ex3_1_6

//============
//Parameter section
parameter Real M(unit = "kg") = 300 "Mass of the solid";
parameter Real dp(unit = "mm") = 0.12 "Diameter of the particle";
parameter Real A(unit = "m^2") = 0.30 "Area of cross section of the bed";
parameter Real phi(unit = "-") = 0.88 "Sphericity";
parameter Real rhop(unit = "kg/m^3") = 1000 "Density of water";
parameter Real epslonmf(unit = "-") = 0.42 "Voidage at minimum fluidisation condition";
parameter Real epslon1(unit = "-") = 0 "Void fraction of the bed";
parameter Real rho(unit = "kg/m^3") = 2.374 "Density of particle";
parameter Real mu(unit = "kg/m.s") = 1.845E-05 "Viscosity of the fluid";
parameter Real g(unit = "m/s^2") = 9.80665 "Acceleration due to gravity";

//============
//Variable section
Real Lmf(unit = "m") "Height of bed after fluidization";
Real Deltap(unit = "Pa") "Pressure drop across the bed";
Real vmf(unit = "m/s") "Minimum fluidisation velocity";
Real NRe(unit = "-") "Reynolds number of the fluid";
Real L1(unit = "m") "Length of bed initially";
Real NRe_actual(unit = "-") "Actual reynolds number";
Real vmf_actual(unit = "m/s") "Actual velocity";

//============
//Equation section
equation
L1 = (M/rhop)/A ; // Length of the bed
L1*(1-epslon1) = Lmf*(1-epslonmf) ; // Length of fluidised bed
Deltap = (1-epslonmf)*(rhop - rho)*g*Lmf ; // Pressure drop across the bed
(1.75*NRe^2)/(phi*epslonmf) + (150*(1-epslonmf)*NRe)/(phi^2 * epslonmf^3) = ((dp/1000)^3*rho*(rhop-rho)*g)/(mu^2) ;
NRe = ((dp/1000)*vmf*rho)/mu ; // Minimum fluidisation velocity
NRe_actual = ((33.7^2 + (0.0408*(dp/1000)^3*rho*(rhop-rho)*g)/(mu^2))^0.5) - 33.7 ;
NRe_actual = ((dp/1000)*vmf_actual*rho)/mu ;
           // dp is divided by 1000 to convert mm to m
end Ex3_1_6;
//===================================================
