// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-3: Flow past immersed objects and packed and fluidised bed
//Example 3.2-1 Page 128
//Title: Flow measurement through pitot tube
//================================================
model Ex3_2_1

//===============
// Libraries 
extends Modelica.Constants;

//==============
//Parameter section
parameter Real Do(unit = "mm") = 600 "Diameter of the duct";
parameter Real h_mano(unit = "mm") = 10.7 "Manometer reading";
parameter Real h_static(unit = "mm") = 205 "Static head of pitot tube";
parameter Real rho(unit = "kg/m^3") = 1.043 "Density of flowing fluid";
parameter Real rho_water(unit = "kg/m^3") = 1000 "Density  of manometer fluid";
parameter Real p_atm(unit = "Pa") = 101325 "Atmospheric temperature";
parameter Real mu(unit = "Pa.s") = 2.03E-05 "Viscosity of the fluid";
parameter Real cd(unit = "-") = 0.98 "Discharge coefficient";
parameter Real g(unit = "m/s^2") = 9.80665 "Acceleration due to gravity";

//=============
//Variable section
Real Delp_static(unit = "Pa") "Static pressure head";
Real Delp_pitot(unit = "Pa") "Pressure drop in pitot tube";
Real rho_act(unit = "kg/m^3") "Actual density of the fluid";
Real NRe(unit = "-") "Reynolds number";
Real v(unit = "m/s") "Velocity of the fluid";
Real Q(unit = "m^3/s") "Flow rate of the fluid";
Real A(unit = "m^2") "Area of cross section";
Real p1(unit = "pa") "Pressure of the fluid";
Real v_avg(unit = "m/s") "Average velocity throug the tube";

//===============
//Equation section
equation
Delp_static = (h_static/1000)*g*(rho_water - rho) ; // Static pressure head
p1 = p_atm + Delp_static ; // actual pressure
rho_act = (p1*rho)/(p_atm) ; // Actual density of flowing fluid"
Delp_pitot = (h_mano/1000)*g*(rho_water - rho_act) ; // Pressure drop in pitot tube
v = cd*(2*Delp_pitot/rho_act)^0.5; // Velocity measured by pitot tube
NRe = (Do/1000)*rho_act*v/mu ; // Reynolds number
A = (pi/4)*(Do/1000)^2 ; // Area of cross section
v_avg/v = 0.85 ; // Average velocity of the tube
 // From figure 2.10.2 Vavg/Vmax = 0.85
Q = A * v_avg; // Continuity equation
end Ex3_2_1;
//===============================================
