// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-3: Flow past immersed objects and packed and fluidised bed
//Example 3.3-1 Page 135
//Title: Calculation of break horse power of the pump
//================================================
model Ex3_3_1

//=============
//Parameter section
parameter Real Q(unit = "gal/min") = 40 "Flow rate of the fluid";
parameter Real eff(unit = "-") = 60 "Effeciency of the pump";
parameter Real H(unit = "ft") = 38.5 "Head of the pump";
parameter Real rho(unit = "lbm/ft^3") = 62.4 "Density of the fluid";
parameter Real gc(unit = "lbm.ft/lbf.s^2") = 32.174 "Gravitational constant";

//=============
//Variable section
Real M(unit = "lbm/s") "Mass flow rate of the fluid";
Real Ws(unit = "lbf.ft/lbm") "Shaft work";
Real Break_hp(unit = "hp") "Break horse power";

//=============
//Equation section
equation
M  = Q*rho/(60*7.481) ; // Mass flow rate of the fluid"
    // Q is divided by 60 to convert min to sec
    // Q is divided by 7.481 to convert gal to ft^3
Ws = -H*(gc/gc) ; 
Break_hp = -Ws*M/((eff/100)*550) ; // Break horse power
  // 550 is divided to convert to hp
end Ex3_3_1;
//===============================================
