// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-3: Flow past immersed objects and packed and fluidised bed
//Example 3.4-1 Page 145
//Title: Power consumption in a agitator
//================================================
model Ex3_4_1

//==============
//Parameter section
parameter Real D(unit = "m") = 0.61 "Diameter of the shaft";
parameter Real rho(unit = "kg/m^3") = 929 "Density of the fluid";
parameter Real mu1(unit = "kg/m.s") = 10/1000 "Viscosity 1";
parameter Real mu2(unit = "kg/m.s") = 100000/1000 "Viscosity 1";
parameter Real N(unit = "rev/s") = 1.5 "Rvolutions per second";
parameter Real Np1(unit = "-") = 5 "Power number for the first reynolds number from graph";
parameter Real Np2(unit = "-") = 14 "Power number for the second reynolds number from graph";

//==============
//Variable section
Real NRe_1(unit = "-") "Reynolds number of the fluid";
Real P1(unit = "kW") "Power required for agitation in case 1 ";
Real NRe_2(unit = "-") "Reynolds number of the fluid";
Real P2(unit = "kW") "Power required for agitation in case 2";

//==============
//Equation section
equation
NRe_1 = (D^2*N*rho)/mu1 ;  // Reynols number
P1 = (Np1*N^3*rho*D^5)/1000 ; // Power required
NRe_2 = (D^2*N*rho)/mu2 ;  // Reynols number
P2 = (Np2*N^3*rho*D^5)/1000 ; // Power required
end Ex3_4_1;
//==============================================
