// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-3: Flow past immersed objects and packed and fluidised bed
//Example 3.5-2 Page 160
//Title: Turbulent flow in power law fluid 
//================================================
model Ex3_5_2

//=============
//Parameter section
parameter Real rho(unit = "kg.m^3") = 961 "Density of the fluid";
parameter Real L(unit = "m") = 30.5 "Length of the tube";
parameter Real d(unit = "m") = 0.0508 "Diameter of the tube";
parameter Real v(unit = "m/s") = 6.1 "Velocity of the fluid";
parameter Real K(unit = "Ns/m^2") = 2.744 "Rheological property";
parameter Real n(unit = "-") = 0.3 "Rhelogical properties";
parameter Real f(unit = "-") = 0.0032  "Fricion factor";

//=============
//Variable section
Real Delp(unit = "kPa") "Pressure drop";
Real NRe(unit = "-") "Reynolds number";

//=============
//Equation section
equation
NRe = (d^n * v^(2-n) * rho)/(K*8^(n-1)) ; // Reynolds number
Delp =  4*f*rho*(L/d)*(v^2)/(2*1000) ; // Pressure drop
   // It is divided to convert Pa to kPa
end Ex3_5_2;
//==============================================
