// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.11-1 Page 285
//Title: Radiation between two parallel planes
//================================================
model Ex4_11_1

//===============
//Parameter section
parameter Real epslon1(unit = "-") = 0.8 "Emissivity of the surface 1";
parameter Real epslon2(unit = "-") = 0.7 "Emissivity of the surface 2";
parameter Real T1(unit = "K") = 588.5 "cold end temperature";
parameter Real T2(unit = "K") = 866.5 "Hot end temperature";
parameter Real sigma(unit = "K^4/m^2.W") = 5.676E-08 "Stephen boltzmen constant";

//===============
//Variable section
Real q1_A(unit = "W/m^2") "Heat transfer flux";
Real q2_A(unit = "W/m^2") "Total heat transfer";

//===============
//Equation section
equation
q1_A = sigma*(T2^4 - T1^4)/((1/epslon1)+(1/epslon2) - 1) ; // Heat transferred 
q2_A = sigma*(T2^4 - T1^4) ; // Heat transferred in balck body
end Ex4_11_1;
//=================================================
