// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.11-7 Page 296
//Title: Gas radiation to a furnace enclosure
//================================================
model Ex4_11_7

//===============
//Parameter section
parameter Real D(unit = "m") = 0.3 "Outer diameter of the tube";
parameter Real eG(unit = "-") = 0.064 "Emissivity of the surface 1";
parameter Real alpaG(unit = "-") = 0.048 "Absorbivity of the surface 2";
parameter Real T1(unit = "K") = 600 "cold end temperature";
parameter Real T2(unit = "K") = 1100 "Hot end temperature";
parameter Real sigma(unit = "K^4/m^2.W") = 5.676E-08 "Stephen boltzmen constant";

//===============
//Variable section
Real aG(unit = "-") "Corrected factor for absorbivity";
Real q_A(unit = "W/m^2") "Heat transfer flux";
Real q(unit = "kW") "Amount of heat transfer";

//===============
//Equation section
equation
aG = alpaG*(T2/T1)^0.65 ; // Absorbivity corrected to the temperature
q_A = sigma*(eG*T2^4-aG*T1^4)/1000  ; // Heat transfer flux
 // It is divided by 1000 to convert W to kW
q = q_A*6*D*D; // Heat transferre across 6 sides
end Ex4_11_7;
//=================================================
