// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.12-1 Page 296
//Title: Heating of non newtonian fluid in laminar flow
//================================================
model Ex4_12_1

//===============
// Libraries 
extends Modelica.Constants;

//================
//Parameter section
parameter Real n(unit = "-") = 0.4 "Rheological constant";
parameter Real k(unit = "W/m.K") = 1.212 "Thermal conductivity of fluid";
parameter Real kB(unit = "-") = 123.5 "Graphical values";
parameter Real kW(unit = "-") = 62.5 "Graphical values";
parameter Real L(unit = "m") = 1.524 "Length of the tube";
parameter Real D(unit = "m") = 0.0254 "Diameter of the tube";
parameter Real m(unit = "kg/s") = 7.56E-02 "Mass flow rate of the fluid";
parameter Real Tb1(unit = "K") = 37.8 "cold end temperature";
parameter Real Tw(unit = "K") = 93 "Wall temperature";
parameter Real Cp(unit = "kJ/kg.K") = 2.093 "Specific heat capacity of the fluid";

//================
//Variable section
Real del(unit = "-") "Rheological properties of the fluid";
Real NGz(unit = "-") "Grantez number";
Real gb_ga(unit = "-") "Ratio of gammas";
Real h(unit = "W/m^2.K") "Heat transfer coefficient";
Real delT(unit = "K") "Temperature gradient";
Real Tb(unit = "C") "Actual outlet temperature";

//=================
//Equation section
equation
del = (3*n + 1)/(4*n) ; // Rheological property
NGz = m*Cp*1000/(k*L) ; // Grantez number
 // 1000 is multiplied to convert kJ to J
gb_ga = (kB/kW) ; // Ratio of gammas
h*D/k = 1.75*del^(1/3)*NGz^(1/3)*(gb_ga)^0.14 ; // Heat transfer coefficient
delT = ((Tw-Tb1+Tw)/2)-(Tb/2) ; // Temperature difference
m*Cp*1000*(Tb-Tb1) = (h*pi*D*L)*delT ; // Actual outlet temperature
 // The assumed and actual temperature are close enough
end Ex4_12_1;
//=============================================================
