// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.13-2 Page 306
//Title: Fin efficiency and heat loss from fin
//================================================
model Ex4_13_2

//===============
// Libraries 
extends Modelica.Constants;

//===============
//Parameter section
parameter Real Lc(unit = "m") = 0.041 "Length of the fin";
parameter Real r1(unit = "m") = 0.040 "Radius of the fin";
parameter Real T1(unit = "K") = 523.2 "Hot end temperature";
parameter Real T2(unit = "K") = 343.2 "Cold end temperature";
parameter Real h(unit = "W/m^2.K") = 30 "Heat transfer coefficient";
parameter Real eta(unit = "-") = 0.89 "Fin efficiency" ;

//===============
//Variable section
Real Af(unit = "m^2") "Area of fin";
Real q(unit = "W") "Heat loss from fin";

//===============
//Equation section
equation
Af = 2*pi*((Lc+r1)^2 - r1^2) ; // Fin area
q = eta*h*Af*(T1-T2) ; // Heat transferred throught the fin
end Ex4_13_2;
//================================================
