// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.3-5 Page 232
//Title: Insulating an electrical wire and critical radius
//================================================
model Ex4_3_5

//===============
// Libraries 
extends Modelica.Constants;

//===============
//Parameter section
parameter Real d(unit = "mm") = 1.5 "Electric wire diameter";
parameter Real t(unit = "mm") = 2.5 "Thickness of the plastic insulation";
parameter Real h(unit = "W/m^2.K") = 20 "Heat ransfer coefficient";
parameter Real k(unit = "W/m.K") = 0.4 "Thermal conductivity of insulation";
parameter Real L(unit = "m") = 1 "Length of the wire";
parameter Real T1(unit = "K") = 400 "Inside temperature of the wall";
parameter Real T2(unit = "K") = 300 "Outside temperature of the wall";

//===============
//Variable section
Real r_c(unit = "m") "Critical insulation thickness";
Real r1(unit = "m") "Outer radius";
Real r2(unit = "m") "Inner radius";
Real q1(unit = "W") "Heat loss per unit length without insulation";
Real q2(unit = "W") "Heat loss with insulation";

//===============
//Equation section
equation
r_c = k/h ; // Critical insulation thickness
r1 = d/(2*1000) ; // Outer radius
 // 1000 is divided to convert mm to m
r2 = (t/1000) + r1 ; // Inner radius
q1 = h*(2*pi*r1*L)*(T1-T2) ; // Heat loss without insulation";
q2 = 2*pi*L*(T1-T2)/(((log(r2/r1))/k) + (1/(r2*h))) ; // Heat loss with insulation
end Ex4_3_5;
//======================================================
