// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.4-1 Page 235
//Title: Two dimensional conduction by graphical procedure
//================================================
model Ex4_4_1

//==============
//Parameter section
parameter Real M(unit = "-") = 9.25 "Total number of heat flow lanes";
parameter Real N(unit = "-") = 4 "Number of subdivisions in Node";
parameter Real k(unit = "W/m.K") = 0.9 "Thermal conductivity of insulation";
parameter Real L(unit = "m") = 5 "Length of the wire";
parameter Real T1(unit = "K") = 600 "Inside temperature of the wall";
parameter Real T2(unit = "K") = 400 "Outside temperature of the wall";

//==============
//Variable section
Real q(unit = "W") "Total heat transfer";

//===============
//Equation section
equation
q = 4*((M/N)*k*L*(T1-T2)) ; // Total heat transfer
end Ex4_4_1;
//==================================================
