// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.5-1 Page 240
//Title: Heating of air in turbulent flow
//================================================
model Ex4_5_1

//================
//Parameter section
parameter Real mub(unit = "Pa.s") = 2.60E-05 "Viscosity of air at 477 K";
parameter Real muw(unit = "Pa.s") = 2.64E-05 "Viscosity of air at 488 K";
parameter Real rho_air(unit = "kg/m^3") = 1.509 "Density of air";
parameter Real D(unit = "m") = 0.0254 "Diameter of the pipe";
parameter Real Npr(unit = "-") = 0.686 "Prandle number of the fluid";
parameter Real v(unit = "m/s") = 7.62 "Velocity of the air flow";
parameter Real k(unit = "W/m.K") = 0.03894 "Thermal conductivity of air";
parameter Real Tw(unit = "K") = 488.7 "Inside temperature of the wall";
parameter Real T(unit = "K") = 477.6 "Outside temperature of the wall";

//===============
//Variable section
Real NRe(unit = "-") "Reynolds number";
Real hL(unit = "W/m^2.K") "Heat transfer coefficient";
Real q_A(unit = "W/m^2") "Heat transfer flux";

//================
//Equation section
equation
NRe = D*rho_air*v/mub ; // Reynolds number of air
hL*D/k = 0.027*NRe^0.8*Npr^(1/3)*(mub/muw)^0.14 ; // Heat transfer coefficient
q_A = hL*(Tw-T) ; // Overall heat transferred
end Ex4_5_1;
//==================================================
