// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.5-2 Page 241
//Title: Water heated by steam and trial and error solution
//================================================
model Ex4_5_2

//===============
// Libraries 
extends Modelica.Constants;

//=================
//Parameter section
parameter Real mub(unit = "Pa.s") = 4.32E-04 "Viscosity of steam";
parameter Real muw(unit = "Pa.s") = 3.56E-04 "Viscosity of steam at wall temperature";
parameter Real rho(unit = "kg/m^3") = 980 "Density of air";
parameter Real Di(unit = "m") = 0.0266 "Inner diameter of the pipe";
parameter Real Do(unit = "m") = 0.0334 "Inner diameter of the pipe";
parameter Real Npr(unit = "-") = 2.72 "Prandle number of the fluid";
parameter Real l(unit = "m") = 0.305 "Length of the cylinder";
parameter Real v(unit = "m/s") = 2.44 "Velocity of the steam flowing";
parameter Real k(unit = "W/m.K") = 0.663 "Thermal conductivity of air";
parameter Real kw(unit = "W/m.K") = 45 "Thermal conductivity of steel";
parameter Real Tw_as(unit = "K") = 80 "Inside temperature of the wall";
parameter Real T(unit = "K") = 65.6 "Outside temperature of the wall";
parameter Real ho(unit = "W/m^2.K") = 10500 "Outside heat transfer coefficient";
parameter Real T1(unit = "K") = 107.8 "Exit temperature of the fluid";

//================
//Variable section
Real NRe(unit = "-") "Reynolds number";
Real hL(unit = "W/m^2.K") "Heat transfer coefficient";
Real Ai(unit = "m^2") "Inner area of cylinder";
Real Ao(unit = "m^2") "Outer area of cylinder";
Real Alm1(unit = "m^2") "Logrithmic mean area 1";
Real Ri(unit = "K/W") "Inner resistance";
Real Rm(unit = "K/W") "Mean resistance";
Real Ro(unit = "K/W") "Outer resistance";
Real R(unit = "K/W") "Total resistance";
Real U(unit = "W/m^2.K") "Overall heat transfer coefficient";
Real Tdrop(unit = "K") "Temperature drop across the pipe";
Real Tw(unit = "K") "Actual tube wall temperature";
Real q(unit = "W") "Overall heat transfer";

//=================
//Equation section
equation
NRe = Di*rho*v/mub ; // Reynolds number of air
hL*Di/k = 0.027*NRe^0.8*Npr^(1/3)*(mub/muw)^0.14 ; // Heat transfer coefficient
Ai = pi*Di*l ; // Inner area
Ao = pi*Do*l ; // Middle area
Alm1 = pi*(Do+Di)*l/2 ;// Logrithmic mean area
Ri = 1/(hL*Ai) ; // Inner resistance";
Rm = (Do-Di)/(2*kw*Alm1) ; // Mean resistance
Ro = 1/(ho*Ao) ; // Outer resistance
R = Ri + Rm +Ro ; // Total resistance
U = 1/(Ai*R) ; // Overall heat transfer coefficient
Tdrop = (T1-T)*Ri/R ; // Temperature drop
Tw = Tdrop + T ; // Tube wall temperature
q = U*Ai*(T1-T) ; // Overall heat transfer
end Ex4_5_2;
//====================================================
