// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.5-3 Page 243
//Title: Liquid metal heat transfer inside the tube
//================================================
model Ex4_5_3

//===============
// Libraries 
extends Modelica.Constants;

//==============
//Parameter section
parameter Real D(unit = "m") = 0.05 "Diameter of the pipe";
parameter Real rho(unit = "kg/m^3") = 7400 "Density of the fluid";
parameter Real mu(unit = "Pa.s") = 7.1E-04 "Viscosity of the fluid";
parameter Real m(unit = "kg/s") = 4 "Mass flow rate of the fluid";
parameter Real k(unit = "W/m.K") = 13 "Thermal conductivity of the pipe";
parameter Real Cp(unit = "J/kg.K") = 120 "Specific heat cpacity";
parameter Real T1(unit = "K") = 505 "Inside temperature of the wall";
parameter Real Tw(unit = "K") = 535 "Tube wall temperature";
parameter Real T(unit = "K") = 500 "Outside temperature of the wall";

//==============
//Variable section
Real NRe(unit = "-") "Reynolds number of the fluid";
Real Npr(unit = "-") "Prandle number of the fluid";
Real hL(unit = "W/m^2.K") "Heat transfer coefficient";
Real q(unit = "W") "Overall heat transfer";
Real q_A(unit = "W/m^2") "Heat transfer flux";
Real A_T(unit = "m^2") "Area required for heat transfer";
Real L(unit = "m") "Length of the tube";
Real G(unit = "kg/s.m^2") "Mass velocity of the fluid";
Real A(unit = "m^2") "Area of pipe";

//===============
//Equation section
equation 
A = (pi/4)*D^2 ; // Tube area
G = m/A ; // Mass velocity of the tube
NRe = D*G/mu ; // Reynolds number of the tube
Npr = Cp*mu/k ; // Prandle number
hL = (k/D)*0.625*(NRe*Npr)^0.4 ; // Heat transfer coefficient
q = m*Cp*(T1-T) ; // Heat transfer across the pipe
q_A = hL*(Tw-T1) ; // Heat transfer flux
A_T = q/q_A ; // Area required for heat transfer
A_T = pi*D*L ; // Length of the tube
end Ex4_5_3;
//===================================================
