// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.5-5 Page 246
//Title: Laminar heat transfer and trail and error
//================================================
model Ex4_5_5

//===============
// Libraries 
extends Modelica.Constants;

//==================
//Parameter section
parameter Real D(unit = "ft") = 0.0303 "Diameter of the pipe";
parameter Real L(unit = "ft") = 15 "Length of tube";
parameter Real mub(unit = "lbm/ft.h") = 12.23 "Viscosity of the fluid";
parameter Real muw(unit = "lbm/ft.h") = 4.72 "Viscosity of the fluid";
parameter Real m(unit = "lbm/h") = 80 "Mass flow rate of the fluid";
parameter Real k(unit = "btu/h.ft.F") = 0.083 "Thermal conductivity of the pipe";
parameter Real Cp(unit = "btu/lbm.F") = 0.5 "Specific heat cpacity";
parameter Real T1(unit = "F") = 150 "Inside temperature of the wall";
parameter Real Tw(unit = "F") = 350 "Tube wall temperature";
parameter Real T_as(unit = "F") = 250 "Outside temperature of the wall";

//=================
//Variable section
Real NRe(unit = "-") "Reynolds number of the fluid";
Real Npr(unit = "-") "Prandle number of the fluid";
Real hL(unit = "btu/h.ft^2.F") "Heat transfer coefficient";
Real G(unit = "lb/h.ft^2") "Mass velocity of the fluid";
Real A(unit = "ft^2") "Area of pipe";
Real T(unit = "F") "Exit temperature of the pipe";

//===================
//Equation section
equation
A = (pi/4)*D^2 ; // Tube area
G = m/A ; // Mass velocity of the tube
NRe = D*G/mub ; // Reynolds number of the tube
Npr = Cp*mub/k ; // Prandle number
hL*D/k = 1.86*(NRe*Npr*(D/L))^(1/3)*(mub/muw)^0.14 ; // Heat transfer coefficient
m*Cp*(T-T1) = hL*(pi*D*L)*(((Tw-T1+Tw)/2)-0.5*T) ; // Actual outlet temperature
 // The assumed temperature and the obtained temperature are almost same hence it is acceptable
end Ex4_5_5;
//==========================================================
