// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.8-1 Page 261
//Title: Rate of heat transfer in a jacketted kettle 
//================================================
model Ex4_8_1

//===============
//Variable section
Real deltaT(unit = "C") "Temperature gradient";
Real ho(unit = "W/m^2.K") "Outer heat transfer coefficient";
Real Q(unit = "W/m^2") "Heat flux";
Real Ri(unit = "K/W") "Inner resistance";
Real Rm(unit = "K/W") "middle resistance";
Real Ro(unit = "K/W") "Inner resistance";
Real R(unit = "K/W") "Overall resistance";
Real Tw(unit = "K") "Actual surface temperature";
Real DeltaT(unit = "K") "Temperature difference across boiling film";

//===============
//Parameter section
parameter Real T1(unit = "C") = 115.6 "Outlet temperature of air";
parameter Real Tw_as(unit = "C") = 108.3 "Assumed wall temperature";
parameter Real T2(unit = "C") = 100 "Surface temperature"; 
parameter Real k(unit = "W/m.K") = 16.27 "Thermal conductivity of the pipe";
parameter Real delx(unit = "mm") = 3.2 "Thickness of the vessel";
parameter Real hi(unit = "W/m^2.K") = 10200 "Inside heat trnsfer coefficient";

//================
//Equation section
equation
deltaT = Tw_as - T2 ;// temperature difference between assumed tube wall temp and T2
ho = 5.56*(deltaT)^3 ; // Outside heat transfer coefficient"
Q = ho*deltaT ; // Heat transfer flux
Ri = 1/hi ; // Inner resistance
Rm = (delx/1000)/k ; // Middle resistance
Ro = 1/ho ; // Outer resistance
R = Ri+Rm+Ro ; // Total resistance
DeltaT = (Ro/R)*(T1-T2) ; // Temperature drop across boiling film
Tw = T2 + DeltaT ; // Actual wall temperature
 // The actual wall temperature and assumed were found to be same
end Ex4_8_1;
//=========================================================
