// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-5 Principles of Unsteady State Heat transfer
//Example 5-3-3 Page:342
//Title: Transient state conduction in a can of pea puree
//================================================
model Ex5_3_3

//=============
//Parameter section
parameter Real a(unit = "m^2/s") = 2.007E-07 "Thermal diffusivity of the rectangular box";
parameter Real x(unit = "m") = 0 "Distance from the surface at center";
parameter Real x1(unit = "m") = 0.03405 "Distance from center to top surface";
parameter Real To(unit = "C") = 29.4 "Initial temperature of surface";
parameter Real T1(unit = "C") = 115.6 "Temperature after cooling";
parameter Real t(unit = "h") = 0.75 "Time taken or allowed for cooling";
parameter Real k(unit = "W/m.K") = 0.830 "Thermal conductivity of the solid";
parameter Real h(unit = "W/m^2.K") = 4540 "Heat transfer coefficient";

//============
//Variable section
Real m(unit = "-") "Parameters needed to use in figure";
Real X(unit = "-") "Parameters needed to use in figure";
Real n(unit = "-") "Parameters needed to use in figure";
Real T(unit = "C") "Temperture of top surface";

//===============
//Equation section
equation
m = k/(h*x1); // Parameter needed in graph
X = a*t*3600/(x1^2) ; // Parameter needed in graph
n = x/x1 ; // From top surface the ratio of length
 // From graph Y is 0.13, figure 5.3-8, page 344
0.13 = ((T1-T)/(T1-To)) ; // Temperature of top surface
end Ex5_3_3;
//=============================================================
