// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-5 Principles of Unsteady State Heat transfer
//Example 5-3-4 Page:347
//Title: Two Dimensional conduction in short cylinder
//================================================
model Ex5_3_4

//=============
//Parameter section
parameter Real a(unit = "m^2/s") = 2.007E-07 "Thermal diffusivity of the rectangular box";
parameter Real x(unit = "m") = 0 "Distance from the top surface at center";
parameter Real y(unit = "m") = 0 "Distance from the side surface at center";
parameter Real x1(unit = "m") = 0.03405 "Distance from center to top surface";
parameter Real y1(unit = "m") = 0.0508 "Distance from center to side surface";
parameter Real To(unit = "C") = 29.4 "Initial temperature of surface";
parameter Real T1(unit = "C") = 115.6 "Temperature after cooling";
parameter Real t(unit = "h") = 0.75 "Time taken or allowed for cooling";
parameter Real k(unit = "W/m.K") = 0.830 "Thermal conductivity of the solid";
parameter Real h(unit = "W/m^2.K") = 4540 "Heat transfer coefficient";

//============
//Variable section
Real m_x(unit = "-") "Parameters needed to use in figure";
Real X_x(unit = "-") "Parameters needed to use in figure";
Real n_x(unit = "-") "Parameters needed to use in figure";
Real m_y(unit = "-") "Parameters needed to use in figure";
Real X_y(unit = "-") "Parameters needed to use in figure";
Real n_y(unit = "-") "Parameters needed to use in figure";
Real T_x_y(unit = "C") "Temperture of top surface";

//===============
//Equation section
equation
m_x = k/(h*x1); // Parameter needed in graph
X_x = a*t*3600/(x1^2) ; // Parameter needed in graph
n_x = x/x1 ; // From top surface the ratio of length
m_y = k/(h*y1); // Parameter needed in graph
X_y = a*t*3600/(y1^2) ; // Parameter needed in graph
n_y = y/y1 ; // From side surface the ratio of length
 //From graph Y is 0.13, figure 5.3-8, page 344
 // From graph Y is 0.80, figure 5.3-6, page 341
0.13*0.80 = ((T1-T_x_y)/(T1-To)) ; // Temperature of top surface
end Ex5_3_4;
//======================================================
