// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-5 Principles of Unsteady State Heat transfer
//Example 5-5-2 Page:364
//Title: Freezing of meet
//================================================
model Ex5_5_2

//==============
//Parameter section
parameter Real lamda_f(unit = "kJ/kg") = 335 "Latent heat of fusion of meat";
parameter Real a(unit = "m") = 0.0635 "Slab of meat";
parameter Real rho(unit = "kg/m^3") = 1057 "Density of the meat";
parameter Real Tf(unit = "K") = 270.4 "Initial freezing temperature of meat";
parameter Real T1(unit = "K") = 244.3 "Air blast freezer";
parameter Real h(unit = "W/m^2.K") = 17 "Heat transfer coefficient";
parameter Real k(unit = "W/m.K") = 1.038 "Thermal conductivity of the unfrozen meet";

//=============
//Variable section
Real lamda(unit = "kJ/kg") "Latent heat of fusion";
Real t(unit = "s") "Time required for freezing";

//==============
//Equation section
equation
lamda = lamda_f*0.75 ; // Latent heat of fusion
 // The meat contains 75% of water
t = (lamda*1000*rho/(Tf-T1))*(a/(2*h) + a^2/(8*k)) ; // Time required for freezing of meat
end Ex5_5_2;
//===============================================
