// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-6 Principles of Mass Transfer
//Example 6_1_1 Page:384
//Title: Molecular diffusion of helium in nitrogen
//================================================
model Ex6_1_1

//==============
//Parameter section
parameter Real pa1(unit = "atm") = 0.6 "Partial pressure at the point 1";
parameter Real pa2(unit = "atm") = 0.2 "Partial pressure at the point 2";
parameter Real z(unit = "m") = 0.2 "Distance between the two points";
parameter Real Da(unit = "m^2/s") = 0.687E-04 "Diffusivity of the component A";
parameter Real R(unit = "Pa.m^3/kmol.K") = 8314 "Universal gas constant";
parameter Real T(unit = "K") = 298 "Temperature at which diffusion takes place";

//==============
//Variable section
Real Ja(unit = "kmol/m^2.s") "Flux of the component A";
 
//==============
//Equation section
equation
Ja = Da*(pa1*101325 - pa2*101325)/(R*T*z) ; // Mass transfer flux 
 // 101325 is multiplied to convert atm to Pa
end Ex6_1_1;
//================================================
