// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-6 Principles of mass transfer
//Example 6_2_1 Page:386
//Title: Equimolar counter diffusion
//================================================
model Ex6_2_1

//=============
//Parameter section
parameter Real pa1(unit = "Pa") = 1.013E+04 "Partial pressure of A at the point 1";
parameter Real pa2(unit = "Pa") = 0.507E+04 "Partial pressure of A at the point 2";
parameter Real p(unit = "Pa") = 101325 "Total system pressure";
parameter Real z(unit = "m") = 0.1 "Distance between the two points";
parameter Real Da(unit = "m^2/s") = 0.23E-04 "Diffusivity of the component A";
parameter Real R(unit = "Pa.m^3/kmol.K") = 8314.3 "Universal gas constant";
parameter Real T(unit = "K") = 298 "Temperature at which diffusion takes place"; 

//=============
//Variable section
Real Ja(unit = "kmol/m^2.s") "Flux of the component A";
Real Jb(unit = "kmol/m^2.s") "Flux of the component B";
Real pb1(unit = "Pa") "Partial pressure of B at point 1";
Real pb2(unit = "Pa") "Partial pressure of B at point 2";

//==============
//Equation section
equation
pb1 = p - pa1 ; // Partial pressure of B at point 1
pb2 = p - pa2 ; // Partial pressure of B at point 2
Ja = Da*(pa1 - pa2)/(R*T*z) ; // Mass transfer flux of A 
Jb = Da*(pb1 - pb2)/(R*T*z) ; // Mass transfer flux of B
end Ex6_2_1;
//==================================================
