// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-6 Principles of mass transfer
//Example 6_2_4 Page:392
//Title: Evaporation of naphthalene sphere
//================================================
model Ex6_2_4

//==============
//Parameter section
parameter Real pa1(unit = "mmHg") = 0.55 "Partial pressure of A at the point 1";
parameter Real pa2(unit = "mmHg") = 0 "Partial pressure of A at the point 2";
parameter Real p(unit = "mmHg") = 760 "Total system pressure";
parameter Real r(unit = "mm") = 2 "Distance between the two points";
parameter Real Da(unit = "m^2/s") = 6.92E-06 "Diffusivity of the component A";
parameter Real R(unit = "Pa.m^3/kmol.K") = 8314 "Universal gas constant";
parameter Real T(unit = "K") = 318 "Temperature at which diffusion takes place";

//=============
//Variable section
Real pbln(unit = "atm") "Average of partial pressure";
Real pb1(unit = "atm") "Partial pressure of B at point 1";
Real pb2(unit = "atm") "Partial pressure of B at point 2";
Real Na(unit = "kmol/m^2.s") "Mass transfer flux";

//==============
//Equation section
equation
pb1 = p - pa1 ; // Partial pressure of B at point 1
pb2 = p - pa2 ; // Partial pressure of B at point 2
pbln = (pb2 + pb1)/2 ; //  Average of partial pressures
Na = (Da*(p/760)*101325*((pa1/760)*101325 - (pa2/760)*101325))/(R*T*(r/1000)*(pbln/760)*101325) ; // Mass transfer flux of A
 // p is divided by 760 and multiplied by 101325 to convert mmHg to atm
end Ex6_2_4;
//==============================================================
