// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-6 Principles of mass transfer
//Example 6_2_5 Page:397
//Title: Estimation of diffusivity of gas mixture
//================================================
model Ex6_2_5

//===============
//Parameter section
parameter Real nuA(unit = "-") = 91.28 "Atomic diffusion volumes of butane";
parameter Real nuB(unit = "-") = 20.1 "Atomic diffusion volumes of air";
parameter Real Ma(unit = "kg/kmol") = 74.1 "Molecular weight of A";
parameter Real Mb(unit = "kg/kmol") = 29 "Moleular weight of B";
parameter Real T1(unit = "K") = 273 "First Temperature at which diffusivity occur";
parameter Real T2(unit = "K") = 298.9 "Second temperature at which diffusivity occur";
parameter Real T3(unit = "K") = 273 "Third temperature at which diffusivity occur";
parameter Real p1(unit = "atm") = 1 "Pressure at third diffusivity occur";
parameter Real p2(unit = "atm") = 1 "Pressure at third diffusivity occur";
parameter Real p3(unit = "atm") = 2 "Pressure at third diffusivity occur";

//==============
//Variable section
Real Da1(unit = "m^2/s") "Diffusivity at 0 C";
Real Da2(unit = "m^2/s") "Diffusivity at 25.9 C";
Real Da3(unit = "m^2/s") "Diffusivity at 0 C and 2 atm";

//===============
//Eqution section
equation
Da1 = (1E-07*T1^1.75*((1/Ma)+(1/Mb))^0.5)/(p1*((nuA)^(1/3) + (nuB)^(1/3))^2) ; //Diffusivity at 273 K
Da2 = (1E-07*T2^1.75*((1/Ma)+(1/Mb))^0.5)/(p2*((nuA)^(1/3) + (nuB)^(1/3))^2) ;//Diffusivity at 298.9 K
Da3 = (1E-07*T3^1.75*((1/Ma)+(1/Mb))^0.5)/(p3*((nuA)^(1/3) + (nuB)^(1/3))^2) ; // Diffusivity at 273 K
end Ex6_2_5;
//===================================================
