// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-6 Principles of mass transfer
//Example 6_4_2 Page:407
//Title: Diffusivity of urea in agar
//================================================
model Ex6_4_2

//=============
//Parameter section
parameter Real Da(unit = "m^2/s") = 0.727E-09 "Diffusivity of ethanol";
parameter Real ca1(unit = "kmol/m^3") = 0.2 "Concentration of A at point 1";
parameter Real ca2(unit = "kmol/m^3") = 0 "Concentration of A at point 2";
parameter Real delz(unit = "m") = 0.04 "Distance between 2 planes";

//============
//Variable section
Real Na(unit = "kmol/m^2.s") "Mass transfer flux";

//=============
//Equation section
equation
Na = Da*(ca1 - ca2)/(delz) ; // Mass transfer flux
end Ex6_4_2;
//=================================================
