// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-6 Principles of mass transfer
//Example 6_5_2 Page:411
//Title: Diffusion through a packing film using permeablity
//================================================
model Ex6_5_2

//=============
//Parameter section
parameter Real Pm(unit = "m^3/s.m^2.atm/m") = 4.17E-12 "Permablity of the packing film";
parameter Real pa1(unit = "atm") = 0.21 "Partial pressure at 1";
parameter Real pa2(unit = "atm") = 0.01 "Partial pressure at 2";
parameter Real delz(unit = "m") = 0.00015 "Thickness of the film";

//=============
//Variable section
Real Na(unit = "kmol/m^2.s") "Mass transfer flux";

//=============
//Equation section
equation
Na = Pm*(pa1 - pa2)/(22.414*delz) ; // Mass transfer flux
end Ex6_5_2;
//===============================================
